/*
 * Decompiled with CFR 0.152.
 */
public class EntityEarthElemental
extends EntityAnimalWatcher {
    private static final int MAGMA_BIT = 256;
    public static final int STONE_NORMAL = EntityEarthElemental.getType(aqz.y, false);
    public static final int STONE_MAGMA = EntityEarthElemental.getType(aqz.y, true);
    public static final int OBSIDIAN_NORMAL = EntityEarthElemental.getType(aqz.au, false);
    public static final int OBSIDIAN_MAGMA = EntityEarthElemental.getType(aqz.au, true);
    public static final int NETHERRACK_NORMAL = EntityEarthElemental.getType(aqz.bg, false);
    public static final int NETHERRACK_MAGMA = EntityEarthElemental.getType(aqz.bg, true);
    public static final int END_STONE_NORMAL = EntityEarthElemental.getType(aqz.bO, false);
    public static final int END_STONE_MAGMA = EntityEarthElemental.getType(aqz.bO, true);
    public static final int CLAY_NORMAL = EntityEarthElemental.getType(aqz.bb, false);
    public static final int CLAY_HARDENED = EntityEarthElemental.getType(aqz.cD, false);
    private int heat = 0;
    private int data_object_id_type;
    private int ticks_until_next_fizz_sound;

    public EntityEarthElemental(abw world) {
        super(world);
        this.k().b(true);
        this.c.a(0, new pp(this));
        this.c.a(1, new pj(this));
        this.c.a(2, new qa(this, uf.class, 1.0, false));
        this.c.a(3, new qa(this, ub.class, 1.0, true));
        this.c.a(4, new qd(this, 1.0));
        this.c.a(6, new qm(this, 1.0));
        this.c.a(7, new px(this, uf.class, 8.0f));
        this.c.a(7, new ql(this));
        this.d.a(1, new qx(this, true));
        this.d.a(2, new qy(this, uf.class, 0, true));
        this.d.a(2, new qy(this, ub.class, 0, false));
    }

    public static int getType(aqz block, boolean is_magma) {
        return block.cF + (is_magma ? 256 : 0);
    }

    @Override
    protected void az() {
        super.az();
        this.setEntityAttribute(tp.b, 20.0);
        this.setEntityAttribute(tp.d, 0.2f);
        this.setEntityAttribute(tp.e, 12.0);
        this.setEntityAttribute(tp.a, 30.0);
    }

    public float getNaturalDefense() {
        return 4.0f;
    }

    @Override
    public float getNaturalDefense(nb damage_source) {
        return super.getNaturalDefense(damage_source) + (damage_source.bypassesMundaneArmor() ? 0.0f : this.getNaturalDefense());
    }

    public int getBlockHarvestLevel() {
        return this.getBlock().getMinHarvestLevel(0);
    }

    @Override
    protected void a() {
        super.a();
        this.data_object_id_type = this.ah.addObject(this.ah.getNextAvailableId(), new Short(0));
    }

    @Override
    public void b(by par1NBTTagCompound) {
        super.b(par1NBTTagCompound);
        par1NBTTagCompound.a("type", (short)this.getType());
        par1NBTTagCompound.a("heat", (short)this.heat);
    }

    @Override
    public void a(by par1NBTTagCompound) {
        super.a(par1NBTTagCompound);
        this.setType(par1NBTTagCompound.d("type"));
        this.heat = par1NBTTagCompound.d("heat");
    }

    @Override
    protected boolean i_() {
        return this.isInNether() || super.i_();
    }

    @Override
    public float a(int x2, int y2, int z2) {
        return 0.0f;
    }

    @Override
    public aqz getBlockBelow() {
        return this.q.getBlock(this.getBlockPosX(), this.getFootBlockPosY() - 1, this.getBlockPosZ());
    }

    public boolean isValidBlock(aqz block) {
        return block == aqz.y || block == aqz.au || block == aqz.bg || block == aqz.bO;
    }

    @Override
    public boolean getCanSpawnHere(boolean perform_light_check) {
        return this.isValidBlock(this.getBlockBelow()) && super.getCanSpawnHere(perform_light_check);
    }

    @Override
    public oi a(oi data) {
        this.setTypeForBlock(this.getBlockBelow(), this.getBlockMaterialAtFeet() == akc.i || this.isClay() && this.getBlockMaterialAtFeet() == akc.o);
        return super.a(data);
    }

    protected int setType(int type) {
        this.ah.b(this.data_object_id_type, (short)type);
        return type;
    }

    public int getType() {
        return this.ah.b(this.data_object_id_type);
    }

    public void setTypeForBlock(aqz block, boolean heated) {
        this.setType(block == aqz.bO ? END_STONE_NORMAL : (block == aqz.bg ? NETHERRACK_NORMAL : (block == aqz.au ? OBSIDIAN_NORMAL : STONE_NORMAL)));
        if (heated) {
            this.convertToMagma();
        }
    }

    public boolean isMagma() {
        if (this.onServer()) {
            return this.heat >= 100;
        }
        return BitHelper.isBitSet(this.getType(), 256);
    }

    public boolean isClay() {
        return this.getClass() == EntityClayGolem.class;
    }

    public boolean isNormalClay() {
        return this.isClay() && !this.isHardenedClay();
    }

    public boolean isHardenedClay() {
        if (!this.isClay()) {
            return false;
        }
        if (this.onServer() && this.heat >= 100) {
            return true;
        }
        return this.getType() == CLAY_HARDENED;
    }

    @Override
    public boolean isImmuneTo(nb damage_source) {
        if (this.isNormalClay()) {
            return super.isImmuneTo(damage_source);
        }
        if (damage_source == nb.h) {
            return false;
        }
        if (damage_source.isMelee() && damage_source.getResponsibleEntity() instanceof sd) {
            return false;
        }
        ye item_stack = damage_source.getItemAttackedWith();
        if (item_stack != null && item_stack.b() instanceof xj && item_stack.getItemAsTool().isEffectiveAgainstBlock(this.getBlock(), 0)) {
            return false;
        }
        return !damage_source.c();
    }

    @Override
    protected boolean bf() {
        return true;
    }

    public void convertToMagma() {
        this.heat = 1000;
        if (this.isClay()) {
            if (this.getType() != this.setType(CLAY_HARDENED)) {
                this.entityFX(EnumEntityFX.smoke);
            }
            return;
        }
        if (this.getType() != this.setType(this.getType() | 0x100)) {
            this.entityFX(EnumEntityFX.smoke);
        }
    }

    public void convertToNormal(boolean steam) {
        this.heat = 0;
        if (this.isClay()) {
            Debug.setErrorMessage("convertToNormal: Why called for Clay Golem?");
            return;
        }
        if (this.getType() != this.setType(BitHelper.clearBit(this.getType(), 256)) && steam) {
            this.causeQuenchEffect();
        }
    }

    @Override
    public void a(sp par1EntityLightningBolt) {
        super.a(par1EntityLightningBolt);
        if (!this.isMagma() && !this.isHardenedClay()) {
            this.convertToMagma();
        } else if (this.heat < 1000) {
            this.heat = 1000;
        }
    }

    @Override
    public void c() {
        super.c();
        if (this.getClass() == EntityClayGolem.class) {
            if (this.getType() != CLAY_NORMAL && this.getType() != CLAY_HARDENED) {
                Debug.setErrorMessage("onLivingUpdate: EntityClayGolem has invalid type: " + this.getType());
            }
        } else if (this.getType() == CLAY_NORMAL || this.getType() == CLAY_HARDENED) {
            Debug.setErrorMessage("onLivingUpdate: EntityEarthElemental has invalid type: " + this.getType());
        }
        if (this.onClient()) {
            if (!this.ae && this.isMagma() && this.isInPrecipitation()) {
                this.spawnSteamParticles(1);
            }
        } else if (this.ae) {
            if (this.isMagma()) {
                this.convertToNormal(true);
            }
            this.heat = 0;
        } else {
            if (this.J() || this.isClay() && this.isInFire()) {
                if (this.heat < 1000 && ++this.heat == 100) {
                    this.convertToMagma();
                }
            } else if (this.heat > 0) {
                boolean was_magma = this.isMagma();
                int cooling = 1;
                if (this.isInPrecipitation()) {
                    ++cooling;
                }
                int x2 = this.getBlockPosX();
                int y2 = this.getFootBlockPosY();
                int z2 = this.getBlockPosZ();
                if (this.q.isFreezing(x2, z2)) {
                    ++cooling;
                }
                if (this.q.g(x2, y2, z2).isFreezing()) {
                    ++cooling;
                }
                if (this.q.g(x2, --y2, z2).isFreezing()) {
                    ++cooling;
                }
                this.heat -= cooling;
                if (this.heat < 0) {
                    this.heat = 0;
                }
                if (was_magma && !this.isMagma()) {
                    this.convertToNormal(this.isInPrecipitation());
                }
            }
            if (this.isMagma() && this.isInPrecipitation() && --this.ticks_until_next_fizz_sound <= 0) {
                this.a("random.fizz", 0.7f, 1.6f + (this.ab.nextFloat() - this.ab.nextFloat()) * 0.4f);
                this.ticks_until_next_fizz_sound = this.ab.nextInt(7) + 2;
            }
        }
    }

    @Override
    protected final boolean preysUpon(nn entity) {
        return entity instanceof ub;
    }

    @Override
    public EntityDamageResult attackEntityAsMob(nn target) {
        this.swingArm();
        EntityDamageResult result = super.attackEntityAsMob(target);
        if (result == null || result.entityWasDestroyed()) {
            return result;
        }
        if (result.entityWasNegativelyAffected() && this.isMagma() && this.aD().nextFloat() < 0.4f) {
            target.d(1 + this.ab.nextInt(8));
        }
        return result;
    }

    public aqz getBlock() {
        return aqz.getBlock(this.getType() & 0xFF);
    }

    @Override
    protected int s() {
        aqz block = this.getBlock();
        return block == aqz.y ? aqz.B.cF : block.cF;
    }

    @Override
    protected void dropFewItems(boolean recently_hit_by_player, nb damage_source) {
        this.b(this.s(), 1);
    }

    @Override
    public int getExperienceValue() {
        return super.getExperienceValue() * 3;
    }

    @Override
    public int bv() {
        return 1;
    }

    @Override
    public boolean healsWithTime() {
        return true;
    }

    @Override
    public boolean isEntityBiologicallyAlive() {
        return false;
    }

    @Override
    public boolean isHarmedByFire() {
        return false;
    }

    @Override
    public boolean isHarmedByLava() {
        return false;
    }

    @Override
    public boolean ax() {
        return false;
    }

    @Override
    public boolean breathesAir() {
        return false;
    }

    @Override
    public int c(float par1) {
        int brightness = super.c(par1);
        if (!this.isMagma()) {
            return brightness;
        }
        int blocklight = brightness & 0xFF;
        int skylight = brightness >> 16;
        blocklight = Math.max(blocklight, 80);
        skylight = Math.max(skylight, 80);
        return skylight << 16 | blocklight;
    }

    @Override
    protected String aO() {
        return "mob.irongolem.hit";
    }

    @Override
    protected String aP() {
        return "mob.irongolem.death";
    }

    @Override
    protected void a(int par1, int par2, int par3, int par4) {
        super.a(par1, par2, par3, par4);
        this.a("mob.irongolem.walk", 0.25f, 1.0f);
    }
}

